# Additive Manufacturing App for the Labeler Platform

## Overview

This application provides specialized visualization and analysis capabilities for additive manufacturing (AM) process monitoring data within the Labeler platform. The app is specifically designed to work with laser powder bed fusion (LPBF) datasets containing multi-modal sensor measurements from the manufacturing process.

## Dataset Information

### Source
The dataset used in this demonstration is based on the NIST Additive Manufacturing Process Monitoring Dataset, available at: https://doi.org/10.18434/mds2-3761

**Citation:**
Yang, Zhuo , Lu, Yan , Lane, Brandon , Yeung, Ho  (2025), *A Fully Registered In-Situ and Ex-Situ Dataset for Metal Powder Bed Fusion Additive Manufacturing: Data Processing, Feature Extraction, Registration, and Uncertainties*, National Institute of Standards and Technology, https://doi.org/10.18434/mds2-3761 (Accessed 2025-09-09)

### Dataset Description
This dataset captures comprehensive process monitoring data from laser powder bed fusion additive manufacturing, including:

- **Parts**: 4 cubic parts (5mm × 5mm × 9mm each)
- **Layers**: 250 layers per part with sequential printing (Part 1 → Part 4)
- **Layer Rotation**: 90° rotation applied between successive layers
- **Measurement Points**: Multiple scan points per layer with 40 extracted features per point

### Feature Schema (40 Columns)
The data includes the following categories of measurements:

#### Machine Control Parameters (1-10)
- `part_number`: Part identifier
- `build_time_us`: Build time in microseconds  
- `cmd_laser_pos_x_mm`, `cmd_laser_pos_y_mm`: Commanded laser position
- `cmd_laser_power_W`: Commanded laser power
- `cmd_scan_speed_mm_per_s`: Calculated commanded scan speed
- `real_laser_pos_x_mm`, `real_laser_pos_y_mm`: Actual laser position from DAQ
- `real_laser_power_W`: Actual laser power from DAQ
- `real_scan_speed_mm_per_s`: Calculated actual scan speed

#### Melt Pool Measurements (11-19)
Ellipse fitting parameters at different thresholds:
- `melt_pool_length_thr80_mm`, `melt_pool_width_thr80_mm`, `melt_pool_area_thr80_mm2`: Threshold 80
- `melt_pool_length_thr100_mm`, `melt_pool_width_thr100_mm`, `melt_pool_area_thr100_mm2`: Threshold 100  
- `melt_pool_length_thr120_mm`, `melt_pool_width_thr120_mm`, `melt_pool_area_thr120_mm2`: Threshold 120

#### Layerwise Imaging (LWI) Measurements (20-37)
Pixel values from powder bed imaging with different LED illuminations and filtering:
- **Powder View**: Original, 3×3 mean, 5×5 mean filtered values for LED A, B, C
- **Exposure View**: Original, 3×3 mean, 5×5 mean filtered values for LED A, B, C

#### X-ray Computed Tomography (XCT) (38-40)
- `xct_voxel_orig`: Original voxel value
- `xct_voxel_mean3`: 3×3×3 mean filtered
- `xct_voxel_mean5`: 5×5×5 mean filtered

## Installation and Usage

### Loading the Dataset
1. **Option A - Custom Provider**: In Labeler Settings → Load custom provider file:
   ```
   apps/additive_manufacturing/additive_manufacturing_data_provider.py
   ```

2. **Option B - Data Folder**: Point the data source to:
   ```
   apps/additive_manufacturing/
   ```

### Record Structure
- **Record IDs**: Format `partXX_LYYYY` (e.g., `part01_L0001`, `part03_L0125`)
- **Time Axis**: Numeric index representing scan point order within each layer
- **Signals**: All 40 features are available for visualization and analysis

## Custom Visualization Capabilities

### 1. Layer Trend by Part
**Purpose**: Track feature evolution across layers for process monitoring and quality assessment.

**Detailed Description**:
This visualization aggregates a selected feature across layers for each part, computing the mean value per layer and plotting the temporal evolution. The plot displays four trend lines (one per part) showing how process parameters or measurement values change as the build progresses from layer 1 to 250.

**Key Features**:
- **Multi-part comparison**: Simultaneous visualization of all 4 parts enables direct comparison of build consistency
- **Temporal analysis**: X-axis represents layer sequence, revealing build progression effects
- **Statistical aggregation**: Each point represents the mean value of all measurement points within that layer
- **Interactive range selection**: Customizable layer range allows focus on specific build phases
- **Theme integration**: Automatically adapts to the application's light/dark theme settings

**Parameters**:
- **Feature Name**: Dropdown selection from all 40 available features
- **Start Layer**: Beginning layer for analysis (default: 1, range: 1-250)
- **End Layer**: Ending layer for analysis (default: 250, range: 1-250)

**Interpretation Guidelines**:
- **Flat trends**: Indicate stable, consistent process conditions
- **Divergent parts**: Suggest part-specific variations or build chamber effects
- **Drift patterns**: Reveal systematic changes due to powder aging, thermal accumulation, or equipment degradation
- **Outlier layers**: May indicate process disruptions, powder spread issues, or recoater problems

**Applications**:
- Process drift detection over extended builds
- Part-to-part consistency validation
- Layer-wise quality monitoring and control
- Build parameter optimization studies
- Equipment health monitoring

### 2. Laser Path Map
**Purpose**: Visualize 2D scan paths with process parameter overlays to understand spatial process variations.

**Detailed Description**:
This visualization creates a 2D spatial map of the laser scan trajectory for a selected layer, overlaying process parameter information through color-coding. The plot shows the actual path traversed by the laser during layer fabrication, with each measurement point represented as a marker whose color corresponds to a selected process parameter value.

**Key Features**:
- **Spatial representation**: True-to-scale XY positioning shows actual build geometry
- **Process overlay**: Color-coding reveals spatial distribution of any selected parameter
- **Path connectivity**: Line connections between points show scan sequence and strategy
- **Dual position sources**: Compare commanded vs. actual laser positions to detect control accuracy
- **Interactive markers**: Adjustable point sizes for optimal visualization at different zoom levels
- **Aspect ratio preservation**: 1:1 scaling maintains geometric accuracy

**Parameters**:
- **Position Source**: 
  - *Real*: Actual laser positions from DAQ sensors (real_laser_pos_x_mm, real_laser_pos_y_mm)
  - *Command*: Commanded positions from motion control (cmd_laser_pos_x_mm, cmd_laser_pos_y_mm)
- **Color Feature**: Dropdown selection from all 40 features for color mapping
- **Point Size**: Marker size adjustment (1-20 pixels) for visibility optimization

**Interpretation Guidelines**:
- **Uniform color distribution**: Indicates consistent process parameters across the layer
- **Color gradients**: May reveal scan direction effects, thermal accumulation, or powder distribution variations
- **Geometric patterns**: Hatch patterns, contour strategies, and fill sequences become visible
- **Position deviations**: Comparing real vs. commanded positions reveals motion system accuracy
- **Scan sequence**: Connected lines show the temporal order of laser movement

**Applications**:
- Scan strategy verification and optimization
- Process parameter spatial distribution analysis
- Motion system accuracy assessment
- Thermal management validation
- Powder spread quality evaluation
- Defect location correlation with scan patterns

### 3. Melt Pool Threshold Scatter
**Purpose**: Analyze melt pool geometry relationships at different detection thresholds to understand process physics and measurement sensitivity.

**Detailed Description**:
This scatter plot visualizes the relationship between melt pool length and width measurements, with area information encoded through both color and marker size. The visualization focuses on a single intensity threshold (80, 100, or 120) to examine how different detection sensitivities affect melt pool characterization. Each point represents one measurement during the layer build process.

**Key Features**:
- **Geometric correlation**: X-Y plot reveals length-width relationships and aspect ratio distributions
- **Area encoding**: Both color intensity and marker size represent melt pool area for enhanced perception
- **Threshold comparison**: Direct comparison between different detection sensitivities
- **Statistical distribution**: Point clouds reveal process variability and measurement uncertainty
- **Outlier detection**: Extreme values or unusual geometry combinations become apparent
- **Physics validation**: Theoretical relationships between dimensions can be verified

**Parameters**:
- **Threshold Selection**: 
  - *80*: Lower intensity threshold, captures larger melt pool boundaries
  - *100*: Medium threshold, balanced sensitivity
  - *120*: Higher threshold, focuses on core high-temperature regions
- **Marker Size Scale**: Scaling factor (5-80) for area-based marker sizing

**Interpretation Guidelines**:
- **Linear relationships**: Strong length-width correlation suggests consistent melt pool shape
- **Clustered distributions**: Tight point clusters indicate stable process conditions
- **Scattered points**: Wide dispersion may indicate process instability or measurement noise
- **Threshold effects**: Different thresholds reveal measurement sensitivity to detection parameters
- **Area-geometry consistency**: Color and size should correlate for physically consistent measurements
- **Outlier patterns**: Extreme values may indicate keyhole formation, lack of fusion, or measurement artifacts

**Applications**:
- Melt pool shape stability analysis
- Threshold sensitivity studies for measurement validation
- Process regime identification (conduction vs. keyhole mode)
- Quality control parameter development
- Physics model validation
- Measurement system characterization

### 4. Layer Histogram Heatmap
**Purpose**: Visualize feature distribution evolution across layers for statistical process monitoring and drift detection.

**Detailed Description**:
This heatmap visualization displays the evolution of a feature's statistical distribution across layers for a selected part. Each row represents one layer, each column represents a histogram bin, and the color intensity indicates the frequency count for that value range. This creates a 2D representation showing how the distribution shape, central tendency, and spread change as the build progresses.

**Key Features**:
- **Temporal distribution tracking**: Rows (Y-axis) represent sequential layers, revealing build progression
- **Statistical binning**: Columns (X-axis) represent value ranges, showing distribution shape
- **Frequency encoding**: Color intensity represents the count of measurements in each bin
- **Global normalization**: Consistent bin boundaries across all layers enable direct comparison
- **Multi-resolution analysis**: Adjustable bin count allows focus on fine details or broad trends
- **Part-specific analysis**: Individual part selection enables focused quality assessment

**Parameters**:
- **Part Selection**: Choose from part01, part02, part03, or part04
- **Feature Name**: Dropdown selection from all 40 available features
- **Bins**: Histogram resolution (5-200 bins) for distribution granularity
- **Layer Start**: Beginning layer for analysis (default: 1, range: 1-250)
- **Layer End**: Ending layer for analysis (default: 250, range: 1-250)

**Interpretation Guidelines**:
- **Vertical bands**: Consistent distribution shape across layers indicates stable process
- **Horizontal shifts**: Distribution mean drift reveals systematic parameter changes
- **Spreading patterns**: Increasing distribution width suggests growing process variability
- **Clustering**: Distinct horizontal bands may indicate different process regimes or build phases
- **Outlier layers**: Unusual distribution patterns may correspond to process disruptions
- **Bimodal distributions**: Multiple peaks may indicate measurement artifacts or process transitions

**Applications**:
- Statistical process control and capability analysis
- Process drift detection over extended builds
- Build phase identification (startup, steady-state, completion effects)
- Measurement system validation and noise characterization
- Quality control limit establishment
- Process optimization based on distribution consistency
- Predictive maintenance through distribution trend analysis

## Data Processing Features

### Signal Processing
- **Smoothing**: Simple moving average with configurable window size
- **Normalization**: Robust scaling using median and IQR
- **Trimming**: Numeric index-based data selection

### Label Categories
Pre-configured labels for defect classification:
- **Defect**: General manufacturing defects
- **Anomaly**: Process anomalies
- **Keyhole**: Keyhole formation events
- **Lack of Fusion**: Insufficient material bonding

## Example Workflows

### Process Monitoring
1. Load a specific layer (e.g., `part02_L0075`)
2. Use **Laser Path Map** to visualize scan strategy with melt pool area overlay
3. Apply **Layer Trend by Part** to track melt pool stability across layers
4. Use **Histogram Heatmap** to detect statistical changes in process parameters

### Quality Analysis
1. Select **Melt Pool Threshold Scatter** to analyze geometry relationships
2. Compare different threshold sensitivities (80 vs. 120)
3. Use the default grapher for detailed time-series analysis of specific features
4. Apply labeling for defect identification and classification

### Multi-Part Comparison
1. Use **Layer Trend by Part** with build parameters (laser power, scan speed)
2. Compare consistency across the 4-part build sequence
3. Identify process drift or part-to-part variations
4. Export labeled data for further analysis

## Technical Notes

- **Data Format**: CSV files without headers (40 columns per row)
- **Time Representation**: Numeric indices (not datetime)
- **Performance**: Optimized for datasets with thousands of measurement points per layer
- **Compatibility**: Integrates with all standard Labeler features (trimming, smoothing, labeling)

## Support and Documentation

For additional information about the Labeler platform and its capabilities, please refer to the main documentation. For dataset-specific questions, consult the original NIST publication at the DOI link provided above.